% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{chisq.test}
\alias{chisq.test}
\alias{chisq.test.default}
\alias{chisq.test.fisher}
\title{Chi-squared test.}
\usage{
chisq.test(x, ...)

\method{chisq.test}{default}(x, ...)

\method{chisq.test}{fisher}(x, ...)
}
\arguments{
\item{x}{Either the output of the \code{\link{agg_index}} function with
\code{method = "fisher"} as parameter, or another R object. In the latter
case, stats::\code{\link[stats]{chisq.test}} is called.}

\item{...}{Further arguments to be passed to
stats::\code{\link[stats]{chisq.test}}.}
}
\value{
Same kind of object as the one returns by the stats
\code{\link[stats]{chisq.test}} function.
}
\description{
Performs chi-squared tests for Fisher's aggregation indices (computed with
either count or incidence data). If another kind of data is provided, the R
standard \code{chisq.test} function is called.
}
\details{
Under the null hypothesis for Fisher's aggregation index (index = 1, i.e. a
random pattern is observed), (N - 1)*index follows a chi-squared distribution
with N - 1 degrees of freedom. N is the number of sampling units.
}
\examples{
# For incidence data:
my_incidence <- incidence(tobacco_viruses)
my_fisher <- agg_index(my_incidence, method = "fisher")
chisq.test(my_fisher)

}
\references{
For count and incidence data:

Madden LV, Hughes G. 1995. Plant disease incidence: Distributions,
heterogeneity, and temporal analysis. Annual Review of Phytopathology 33(1):
529–564.
\doi{10.1146/annurev.py.33.090195.002525}

Patil GP, Stiteler WM. 1973. Concepts of aggregation and their
quantification: a critical review with some new results and applications.
Researches on Population Ecology, 15(1): 238-254.
}
\seealso{
\code{\link{calpha.test}}, \code{\link{z.test}}
}
