% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{z.test}
\alias{z.test}
\alias{z.test.default}
\alias{z.test.fisher}
\title{Z-test.}
\usage{
z.test(x, ...)

\method{z.test}{default}(x, ...)

\method{z.test}{fisher}(
  x,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{x}{The output of the \code{\link{agg_index}} function with
\code{method = "fisher"} as parameter.}

\item{...}{Not yet implemented.}

\item{alternative}{A character string specifying the alternative hypothesis.
It must be one of "two.sided" (default), "less" or "greater".}

\item{conf.level}{The confidence level of the interval.}
}
\value{
Same kind of object as the one returns by the stats
\code{\link[stats]{chisq.test}} function for example.
}
\description{
Performs z-tests for Fisher's aggregation indices (computed with either count
or incidence data).
}
\details{
For two-sided tests with a confidence level of 95%, if -1.96 <= z <= 1.95,
the spatial pattern would be random. If z < -1.96 or z > 1.96, it would be
uniform or aggregated, respectively.
}
\examples{
# For incidence data:
my_incidence <- incidence(tobacco_viruses)
my_fisher <- agg_index(my_incidence, method = "fisher")
z.test(my_fisher)

}
\references{
For count and incidence data:

Moradi-Vajargah M, Golizadeh A, Rafiee-Dastjerdi H, Zalucki MP, Hassanpour M,
Naseri B. 2011. Population density and spatial distribution pattern of Hypera
postica (Coleoptera: Curculionidae) in Ardabil, Iran. Notulae Botanicae Horti
Agrobotanici Cluj-Napoca, 39(2): 42-48.

Sun P, Madden LV. 1997. Using a normal approximation to test for the binomial
distribution. Biometrical journal, 39(5): 533-544.
}
\seealso{
\code{\link{calpha.test}}, \code{\link{chisq.test}}
}
