% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.episensr_booted.R
\name{plot.episensr_booted}
\alias{plot.episensr_booted}
\title{Plot of bootstrap simulation output for selection and misclassification bias}
\usage{
\method{plot}{episensr_booted}(x, association = c("rr", "or"), ...)
}
\arguments{
\item{x}{An object of class "episensr.booted" returned from the episensr bootstrap generation function.}

\item{association}{Choice between bias adjusted relative risk (rr) and odds ratio (or).}

\item{...}{Other unused arguments.}
}
\description{
This takes an episensr bootstrap object and produces the plot of bootstrap
replicates for selection or misclassification bias of the variable of interest,
either relative risk or odds ratio. It also draws the confidence interval.
}
\examples{
misclass_eval <- misclass(matrix(c(215, 1449, 668, 4296),
dimnames = list(c("Breast cancer+", "Breast cancer-"),
c("Smoker+", "Smoker-")),
nrow = 2, byrow = TRUE),
type = "exposure",
bias_parms = c(.78, .78, .99, .99))

set.seed(123)
misclass_boot <- boot_bias(misclass_eval)
plot(misclass_boot, association = "rr")

}
\seealso{
\code{\link{boot_bias}, \link{selection}, \link{misclass}}

Other visualization: 
\code{\link{plot.episensr_probsens}()},
\code{\link{plot.mbias}()}
}
\concept{visualization}
