% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_incubation.R
\name{fit_gamma_incubation_dist}
\alias{fit_gamma_incubation_dist}
\title{Fit discrite gamma distribution to incubation periods}
\usage{
fit_gamma_incubation_dist(
  x,
  date_of_onset,
  exposure,
  exposure_end = NULL,
  nsamples = 1000,
  ...
)
}
\arguments{
\item{x}{the linelist data (data.frame or linelist object) containing at
least a column containing the exposure dates and one containing the onset
dates.}

\item{date_of_onset}{the name of the column containing the onset dates (bare
variable name or in quotes)}

\item{exposure}{the name of the column containing the exposure dates
(bare variable name or in quotes)}

\item{exposure_end}{the name of a column containing dates representing the
end of the exposure period. This is `NULL` by default, indicating
all exposures are known and in the `exposure` column.}

\item{nsamples}{The number of samples to draw from the empirical
distribution to fit on (dafaults to 1000)}

\item{...}{passed to fit_disc_gamma}
}
\value{
see [fit_disc_gamma()]
}
\description{
A wrapper around fit_disc_gamma to fit a discrete gamma distribution to
incubation periods derived from exposure and onset dates. Can take into
account uncertain dates of exposure.
}
\examples{

random_dates <- as.Date("2020-01-01") + sample(0:30, 50, replace = TRUE)
x <- data.frame(date_of_onset = random_dates)

mkexposures <- function(x) x - round(rgamma(sample.int(5, size = 1), shape = 12, rate = 3))
exposures <- sapply(x$date_of_onset, mkexposures)
x$date_exposure <- exposures

fit <- fit_gamma_incubation_dist(x, date_of_onset, date_exposure)
plot(0:20, fit$distribution$d(0:20),
     type = "h", lwd = 10, lend = 2, col = "#49D193",
     xlab = "Days since exposure",
     ylab = "Probability",
     main = "Incubation time distribution")

}
\author{
Flavio Finger, \email{flavio.finger@lshtm.ac.uk}
}
