% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d_devlin.R
\name{figure_1_2_3}
\alias{figure_1_2_3}
\title{Figure 1.2.3: Percentage of Respondents Who Worsened in Each EQ-5D Dimension, by Group}
\usage{
figure_1_2_3(
  df,
  name_id,
  name_groupvar,
  names_eq5d = NULL,
  name_fu = NULL,
  levels_fu = NULL
)
}
\arguments{
\item{df}{A data frame containing EQ-5D columns, a grouping variable, an ID column, and a follow-up column}

\item{name_id}{A character string for the patient ID column}

\item{name_groupvar}{A character string for the grouping column (e.g., procedure)}

\item{names_eq5d}{A character vector of EQ-5D dimension names}

\item{name_fu}{A character string for the follow-up column}

\item{levels_fu}{A character vector of length 2, specifying the order of the follow-up levels (e.g., c("Pre-op","Post-op"))}
}
\value{
A list containing:
  \item{plot_data}{A data frame of "Worsen" percentages by group and dimension}
  \item{p}{A ggplot2 object produced by `.pchc_plot_by_dim()`}
}
\description{
This function identifies respondents with a "Worsen" PCHC state (i.e., overall
health state got worse between levels_fu[1] and levels_fu[2]), checks
dimension-specific changes (e.g., mo_diff < 0), and summarizes by a grouping variable
(e.g., procedure) and time points. It returns a data table and a ggplot object.
}
\examples{
result <- figure_1_2_3(
  df = example_data,
  name_id = "id",
  name_groupvar = "procedure",
  names_eq5d = c("mo", "sc", "ua", "pd", "ad"),
  name_fu = "time",
  levels_fu = c("Pre-op","Post-op")
)
result$p        # shows the plot
result$plot_data  # shows the summary table

}
