% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispro.R
\name{dispro}
\alias{dispro}
\title{Electoral Disproportionality}
\usage{
dispro(tidy_data, method, scale = 1)
}
\arguments{
\item{tidy_data}{data.frame that contains the following variables with these names:
\itemize{
         \item{\code{election}: year of election.}
         \item{\code{unit}: the unit of analysis (province, department ...)}
         \item{\code{party}: name of the political parties that obtain votes.}
         \item{\code{votes}: votes obtained by each party.}
         \item{\code{seats}: .}
        }
If the data is not structured in this way you can order it with: \code{\link{convert_esaps}}.}

\item{method}{Method to calculate electoral volatility:
\itemize{
        \item{\code{method = "Rae"} or \code{method = 1}.}
        \item{\code{method = "Loosemore and Hanby"} or \code{method = 2}.}
        \item{\code{method = "Lijphart_1"} or \code{method = 3}.}
        \item{\code{method = "Lijphart_2"} or \code{method = 4}.}
        \item{\code{method = "Gallagher"} or \code{method = 5}.}
        \item{\code{method = "Cox and Shugart"} or \code{method = 6}.}
        }}

\item{scale}{By default it is \code{100}, the indices will vary between 0 and 100.
If \code{scale = 1} the variation will be between 0 and 1.}
}
\value{
data.frame.
}
\description{
Electoral Disproportionality: Rae (1971), Loosemore and Hanby (1971), Lijphart (1986),
    Lijphart (1994), Gallagher (1991) and Cox and Shugart (1991).
}
\examples{
votes <- data.frame(election = rep(c(2000, 2005), each = 4),
                   unit  = rep(c("ARG", "URY"), each = 4),
                   party = c("party_A", "party_B","party_C","party_D"),
                   votes = c(20, 30, 40, 10, 30, 35, 25, 10),
                   seats = c(25, 20, 40, 15, 35, 30, 30, 5)
                   )

dispro(votes, 1:6, 1)
dispro(votes, 3)
dispro(tidy_data = votes, method = 3:5)
dispro(tidy_data = votes, method = c(1,3,6))
dispro(tidy_data = votes, method = c("Rae", "Gallagher"))


}
\author{
Nicolas Schmidt \email{nschmidt@cienciassociales.edu.uy}
}
