% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_kurtosis.R
\name{signal_kurtosis}
\alias{signal_kurtosis}
\title{Calculate signal kurtosis}
\usage{
signal_kurtosis(data, window = 200)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{window}{\code{Numeric} value, size of the running window, in 
number of samples}
}
\value{
\code{Numeric} running kurtosis of the input signal.
}
\description{
This function calculates the running kurtosis of a seismic signal 
and returns that characteristic function.
}
\examples{

## load example data
data(rockfall)

## calculate kurtosis
rockfall_kurtosis <- signal_kurtosis(data = rockfall_eseis,
                                     window = 200)

}
\author{
Michael Dietze
}
\keyword{eseis}
