% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eselectsim.R
\name{eselectsim}
\alias{eselectsim}
\title{Simulation trials with endpoint selection and sample size reassessment for composite endpoints based on blinded data}
\usage{
eselectsim(
  ss_arm,
  p0_e1,
  OR1,
  p0_e2,
  OR2,
  p0_ce,
  p_init = 1,
  criteria = "SS",
  H0_e1 = FALSE,
  H0_e2 = FALSE,
  SS_r = TRUE,
  alpha = 0.05,
  beta = 0.2
)
}
\arguments{
\item{ss_arm}{numeric parameter, sample size per arm}

\item{p0_e1}{numeric parameter, probability of occurrence E1 in the control group}

\item{OR1}{numeric parameter, Odds ratio for the endpoint 1}

\item{p0_e2}{numeric parameter, probability of occurrence E2 in the control group}

\item{OR2}{numeric parameter, Odds ratio for the endpoint 2}

\item{p0_ce}{numeric parameter, probability of occurrence composite endpoint in the control group}

\item{p_init}{numeric parameter, percentage of sample size used in the interim}

\item{criteria}{decision criteria to choose between the composite endpoint or the endpoint 1 as primary endpoint ("SS": Ratio sample sizes, "ARE": Asymptotic Relative Efficiency).}

\item{H0_e1}{Simulate under true null hypothesis for the endpoint E1 (TRUE/FALSE).}

\item{H0_e2}{Simulate under true null hypothesis for the endpoint E2 (TRUE/FALSE).}

\item{SS_r}{Sample size reassessment (TRUE/FALSE). If TRUE, in those cases where the sample size is less than the needed for achieving the pre-specified power, additional subjects are added after recalculating the sample size. If FALSE, no more subjects are added in the study.}

\item{alpha}{Type I error.}

\item{beta}{Type II error.}
}
\value{
This function returns the decision (Decision = 1, meaning the chosen endpoint is the composite endpoint; and Decision = 0, meaning the chosen endpoint is the relevant endpoint) and the statistic to test the primary hypothesis according to the decision.
}
\description{
This function simulates trials with endpoint selection and sample size reassessment  for composite binary endpoints based on blinded data. The composite endpoint is assumed to be a binary endpoint formed by a combination of two events (E1 and E2). We assume that the endpoint 1 is more relevant for the clinical question than endpoint 2. This function simulates a trial based on the design parameters and use the algorithm implemented in eselect() to select the primary endpoint and recalculate the sample size accordingly.
}
\references{
Bofill Roig, M., Gómez Melis, G., Posch, M., & Koenig, F. (2022). Adaptive clinical trial designs with blinded selection of binary composite endpoints and sample size reassessment. Biostatistics (in press). arXiv e-prints, arXiv-2206 (https://doi.org/10.48550/arXiv.2206.09639).
}
