% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esemifar.R, R/forecasts.R
\docType{package}
\name{esemifar}
\alias{esemifar}
\alias{esemifar-package}
\title{esemifar: A package for data-driven nonparametric estimation of the trend and
its derivatives in equidistant time series.}
\usage{
esemifar(nonpar_model, par_model)
}
\arguments{
\item{nonpar_model}{an estimation object returned by \code{\link{gsmooth}}.}

\item{par_model}{an estimation object returned by \code{\link[fracdiff]{fracdiff}} fitted
to the residuals of \code{nonpar_model}.}
}
\value{
The function returns a list of class \code{"esemifar"} with elements
\code{nonpar_model} and \code{par_model}.
}
\description{
The \code{esemifar} package provides different applicable functions for the
estimation of the trend or its derivatives in equidistant time series.
The main functions include an automated bandwidth selection method for time
series with long-memory errors.

An alternative method to create an ESEMIFAR estimation object
stitched together from a nonparametric and a parametric part.
}
\details{
The main function \code{\link{tsmoothlm}} already returns a fully estimated
ESEMIFAR model. In some instances, alternative specifications of the
nonparametric and parametric model parts are needed, for which
\code{\link{tsmoothlm}} with its automated estimation algorithm does not
provide sufficient flexibility. Therefore, this function allows to stitch
together a nonparametric model part returned by \code{\link{gsmooth}} and
a FARIMA part for the residuals obtained via \code{\link[fracdiff]{fracdiff}}.
The resulting object can then be used for forecasting.
}
\section{Functions (version 1.0.0)}{

The \code{esemifar} functions are either meant for calculating nonparametric
estimates of the trend of a time series or its derivatives.


\code{dsmoothlm} is a function that calculates the derivatives of the
trend after obtaining the optimal bandwidth by an iterative plug-in
algorithm.

\code{tsmoothlm} is the central function of the package. It allows
the user to conduct a local polynomial regression of the trend based on
an optimal bandwidth that is obtained by an iterative plug-in algorithm.
Inflation rate (and other factors) can be manually
and individually adjusted as arguments in the function
(see also: \code{\link{tsmoothlm}}).

\code{critMatlm} is a quick tool for the calculation of information criteria
for FARIMA(\eqn{p,d,q}) models with different order combinations \eqn{p} and
\eqn{q}. The function returns a matrix with the obtained values of the
selected criterion for the different combinations of \eqn{p} and \eqn{q}
(see also: \code{\link{critMatlm}}).
}

\section{Datasets}{

The package includes two datasets: \code{airLDN} (see also:
\code{\link{airLDN}}) with daily observations of individual air pollutants
from 2014 to 2020 and \code{gdpG7} (see also: \code{\link{gdpG7}}) that has
data concerning the quarterly G7 GDP between Q1 1962 and Q4 2019.
}

\section{License}{

The package is distributed under the General Public License v3
([GPL-3](https://tldrlegal.com/license/gnu-general-public-license-v3-(gpl-3))).
}

\examples{
lgdp <- log(esemifar::gdpG7$gdp)
nonpar <- gsmooth(lgdp, b = 0.15)
res <- nonpar$res
par <- fracdiff::fracdiff(res, nar = 1, nma = 1)
model <- esemifar(nonpar_model = nonpar, par_model = par)
model

}
\references{
Beran, J. and Y. Feng (2002a). Iterative plug-in algorithms for SEMIFAR
models - definition, convergence, and asymptotic properties. Journal of
Computational and Graphical Statistics 11(3), 690-713.

Beran, J. and Feng, Y. (2002b). Local polynomial fitting with long-memory,
short-memory and antipersistent errors. Annals of the Institute of
Statistical Mathematics, 54(2), 291-311.

Beran, J. and Feng, Y. (2002c). SEMIFAR models - a semiparametric approach
to modelling trends, longrange dependence and nonstationarity. Computational
Statistics & Data Analysis 40(2), 393-419.

Letmathe, S., Beran, J. and Feng, Y. (2023). An extended exponential SEMIFAR
model with application in R. Communications in Statistics - Theory and Methods:
1-13.
}
\author{
\itemize{
\item Yuanhua Feng (Department of Economics, Paderborn University), \cr
Author of the Algorithms \cr
Website: \url{https://wiwi.uni-paderborn.de/en/dep4/feng/}
\item Sebastian Letmathe, \cr
Author (and Original Package Creator and Maintainer)
\item Dominik Schulz, \cr
Author and Current Package Creator and Maintainer
}

\itemize{
\item Dominik Schulz (Scientific Employee) (Department of Economics,
Paderborn University), \cr
Author
}
}
