% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R, R/02_Bern.R, R/02_Binom.R,
%   R/02_Cat.R, R/02_Cauchy.R, R/02_Dirichlet.R, R/02_Exp.R, R/02_Gam.R,
%   R/02_Geom.R, R/02_Laplace.R, R/02_Lnorm.R, R/02_Multinom.R, R/02_Nbinom.R,
%   R/02_Norm.R, R/02_Pois.R, R/02_Unif.R, R/02_Weib.R
\name{ll}
\alias{ll}
\alias{ll,ANY,ANY,character-method}
\alias{llbern}
\alias{llbinom}
\alias{llcat}
\alias{llcauchy}
\alias{lldirichlet}
\alias{llexp}
\alias{llgamma}
\alias{llgeom}
\alias{lllaplace}
\alias{lllnorm}
\alias{llMultinom}
\alias{llnbinom}
\alias{llnorm}
\alias{llpois}
\alias{llunif}
\alias{llweib}
\title{Log-Likelihood}
\usage{
ll(x, prm, distr, ...)

\S4method{ll}{ANY,ANY,character}(x, prm, distr, ...)

llbern(x, prob)

llbinom(x, size, prob)

llcat(x, prob)

llcauchy(x, location, scale)

lldirichlet(x, alpha)

llexp(x, rate)

llgamma(x, shape, scale)

llgeom(x, prob)

lllaplace(x, mu, sigma)

lllnorm(x, meanlog, sdlog)

llMultinom(x, size, prob)

llnbinom(x, size, prob)

llnorm(x, mean, sd)

llpois(x, lambda)

llunif(x, min, max)

llweib(x, shape, scale)
}
\arguments{
\item{x}{numeric. A sample under estimation.}

\item{prm}{numeric. A vector of the distribution parameters.}

\item{distr}{A subclass of \code{Distribution}. The distribution family assumed.}

\item{...}{extra arguments.}

\item{location, alpha, mu, sigma, meanlog, sdlog, min, max, size, prob, shape, rate, scale, mean, sd, lambda}{numeric.
Distribution parameters.}
}
\value{
Numeric. The value of the log-likelihood function.
}
\description{
These functions calculate the log-likelihood of an IID sample for specific
values of the distribution parameters. See Details.
}
\details{
The log-likelihood functions are provided in two forms: the \verb{ll<name>}
distribution-specific version that follows the base R conventions, and the
S4 generic \code{ll}.
}
