% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.etree}
\alias{plot.etree}
\title{Visualization of Energy Trees}
\usage{
\method{plot}{etree}(
  x,
  main = NULL,
  terminal_panel = NULL,
  tp_args = list(),
  inner_panel = node_inner,
  ip_args = list(),
  edge_panel = edge_simple,
  ep_args = list(),
  type = c("extended", "simple"),
  drop_terminal = NULL,
  tnex = NULL,
  newpage = TRUE,
  pop = TRUE,
  gp = gpar(),
  ...
)
}
\arguments{
\item{x}{An object of class \code{"etree"}, i.e., a fitted Energy Tree.}

\item{main}{Optional title for the plot.}

\item{terminal_panel}{Optional panel function of the form
\code{function(node)} plotting the terminal nodes. Alternatively, a panel
generating function of class \code{"grapcon_generator"} that is called with
arguments \code{x} and \code{tp_args} to set up a panel function. By
default, an appropriate panel function is chosen depending on the scale of
the dependent variable.}

\item{tp_args}{List of arguments passed to \code{terminal_panel} if this is
a \code{"grapcon_generator"} object.}

\item{inner_panel}{Optional panel function of the form
\code{function(node)} plotting the inner nodes. Alternatively, a panel
generating function of class \code{"grapcon_generator"} that is called with
arguments \code{x} and \code{ip_args} to set up a panel function.}

\item{ip_args}{List of arguments passed to \code{inner_panel} if this is a
\code{"grapcon_generator"} object.}

\item{edge_panel}{Optional panel function of the form
\code{function(split, ordered = FALSE, left = TRUE)} plotting the edges.
Alternatively, a panel generating function of class
\code{"grapcon_generator"} that is called with arguments \code{x} and
\code{ep_args} to set up a panel function.}

\item{ep_args}{List of arguments passed to \code{edge_panel} if this is a
\code{"grapcon_generator"} object.}

\item{type}{Character specifying the complexity of the plot:
\code{extended} tries to visualize the distribution of the response
variable in each terminal node whereas \code{simple} only gives some
summary information.}

\item{drop_terminal}{Logical indicating whether all terminal nodes should
be plotted at the bottom.}

\item{tnex}{Numeric value giving the terminal node extension in relation to
the inner nodes.}

\item{newpage}{Logical indicating whether \code{grid.newpage()} should be
called.}

\item{pop}{Logical indicating whether the viewport tree should be popped before
return.}

\item{gp}{Graphical parameters.}

\item{...}{Additional arguments.}
}
\value{
No return value, called for side effects (plotting the tree).
}
\description{
Returns the plot of an object of class \code{"etree"}.
}
\details{
The \code{plot()} method for \code{"etree"} objects allows for the
visualization of fitted Energy Trees,  as returned by
\code{\link[etree:etree]{etree()}} or as contained in the \code{ensemble}
element of a fitted Random Energy Forest.
}
