% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rast.R
\name{plot_rast}
\alias{plot_rast}
\title{Plot rast (SpatRaster) object}
\usage{
plot_rast(
  r,
  color,
  ncolor = 21,
  proj = FALSE,
  plg = list(tic = "none", shrink = 1),
  pax = list(),
  latitude = TRUE,
  longitude = TRUE,
  int = 10,
  grid = FALSE,
  grid_int = int,
  grid_col = "#666666",
  add_range = FALSE,
  ndig = 2,
  log = FALSE,
  range,
  scale,
  min = -3,
  max,
  unit,
  ...
)
}
\arguments{
\item{r}{raster}

\item{color}{color scale, or name of a custom color scale (see notes)}

\item{ncolor}{number of colors}

\item{proj}{TRUE to project the raster to lat-lon}

\item{plg}{list of parameters passed to terra::add_legend}

\item{pax}{list of parameters passed to graphics::axis}

\item{latitude}{add a latitude axis}

\item{longitude}{add a longitude axis}

\item{int}{interval of latitude and longitude lines}

\item{grid}{add grid (graticule style)}

\item{grid_int}{interval of grid lines}

\item{grid_col}{color for grid lines}

\item{add_range}{add legend with max, average and min r values}

\item{ndig}{number of digits for legend_range}

\item{log}{TRUE to plot in log-scale}

\item{range}{range of original values to plot}

\item{scale}{variable multiplier (not affect min/max/range)}

\item{min}{minimum log value for log scale (default is -3)}

\item{max}{maximum log value for log scale}

\item{unit}{title for color bar}

\item{...}{arguments to be passing to terra::plot}
}
\value{
No return value
}
\description{
Custon plot for SpatRaster (terra R-package) object based on terra package
}
\note{
color scales including: 'eva3', 'eva4', 'blues', 'diff', and 'rain'. Also reverse version with addition of a r ('eva3r' is the default).
}
\examples{
wrf <- paste(system.file("extdata", package = "eva3dm"),
                         "/wrfinput_d01", sep="")

r <- wrf_rast(file=wrf, name='XLAT')

plot_rast(r)

}
