% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpdMultScore.R
\name{gpdMultScore}
\alias{gpdMultScore}
\title{GPD Multiplier Score Test}
\usage{
gpdMultScore(data, bootnum, information = c("expected", "observed"))
}
\arguments{
\item{data}{Data should be in vector form.}

\item{bootnum}{Number of bootstrap replicates.}

\item{information}{To use expected (default) or observed information in the test.}
}
\value{
\item{statistic}{Test statistic.}
\item{p.value}{P-value for the test.}
\item{theta}{Value of theta used in the test.}
}
\description{
Fast weighted bootstrap alternative to the parametric bootstrap procedure for the Generalized Pareto score test.
}
\examples{
x <- rgpd(100, loc = 0, scale = 1, shape = 0.25)
gpdMultScore(x, bootnum = 1000)
}
