% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abtew.R
\name{abtew}
\alias{abtew}
\alias{abtew,missing,missing-method}
\alias{abtew,Raster,Raster-method}
\alias{abtew,character,character-method}
\title{Calculate Potential Evapotranspiration (PET) using Abtew Method}
\usage{
abtew(tavg, rs, x = NULL)

\S4method{abtew}{missing,missing}(x)

\S4method{abtew}{Raster,Raster}(tavg, rs, x = NULL)

\S4method{abtew}{character,character}(tavg, rs, x = NULL)
}
\arguments{
\item{tavg}{Raster* object or file path; average temperature (°C)}

\item{rs}{Raster* object or file path; shortwave radiation (MJ m-2 day-1)}

\item{x}{A `data.table` with columns: "lon", "lat", "date", "tavg", "rs"}
}
\value{
RasterBrick or data.table of PET values (mm/day)
}
\description{
The function \code{abtew} computes PET by Abtew method
}
\details{
For Raster inputs, provide raster objects or file paths for `tavg` and `rs`.
For `data.table` input, provide a single `data.table` with columns: 
"lon", "lat", "date", "tavg", and "rs".
}
\keyword{internal}
