% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priestly_taylor.R
\name{priestley_taylor}
\alias{priestley_taylor}
\alias{priestley_taylor,missing,missing,missing,missing-method}
\alias{priestley_taylor,Raster,Raster,ANY,ANY-method}
\alias{priestley_taylor,character,character,ANY,ANY-method}
\title{Calculate Potential Evapotranspiration (PET) using Priestley-Taylor Method}
\usage{
priestley_taylor(tavg, rn, elevation = NULL, pres = NULL, x = NULL)

\S4method{priestley_taylor}{missing,missing,missing,missing}(x)

\S4method{priestley_taylor}{Raster,Raster,ANY,ANY}(tavg, rn, elevation = NULL, pres = NULL, x = NULL)

\S4method{priestley_taylor}{character,character,ANY,ANY}(tavg, rn, elevation = NULL, pres = NULL, x = NULL)
}
\arguments{
\item{tavg}{Raster* object or file path; average temperature (°C)}

\item{rn}{Raster* object or file path; net radiation (MJ m-2 day-1)}

\item{elevation}{Raster* object or file path; elevation (m). Optional if `pres` is provided.}

\item{pres}{Optional. Raster* object or file path; atmospheric pressure (kPa)}

\item{x}{A `data.table` with columns: "lon", "lat", "date", "tavg", "rn", and either "elevation" or "pres".}
}
\value{
RasterBrick or data.table of PET values (mm/day)
}
\description{
The function \code{priestley_taylor} computes PET by Priestley-Taylor method.
}
\details{
For Raster inputs, provide raster objects or file paths for `tavg`, `rn`, 
and either `elevation` or `pres`. For `data.table` input, provide a single 
`data.table` with columns: "lon", "lat", "date", "tavg", "rn", and either 
"elevation" or "pres".
}
\keyword{internal}
