% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modal_confidence.R
\name{modal_confidence}
\alias{modal_confidence}
\title{Calculate the modal confidence across event reports}
\usage{
modal_confidence(data, group_var, variables)
}
\arguments{
\item{data}{A data frame containing event report level data.}

\item{group_var}{A character string naming the column that uniquely identifies events (e.g., "event_id").}

\item{variables}{A character vector of column names to assess modal confidence for.}
}
\value{
A tibble with two columns:
\describe{
  \item{variable}{The name of each variable.}
  \item{modal_confidence}{The average share of reports per event that match the modal value.}
}
}
\description{
This function calculates the modal confidence score for one or more variables grouped by an event identifier.
The modal confidence score captures how dominant the most common value is within each event — that is,
the proportion of event reports that agree with the modal (most frequent) value for each variable.
}
\details{
For each variable and event, the function computes the share of event reports that match the modal value.
These proportions are then averaged across all events to produce a single score per variable. The result is
a long-format dataframe that shows which variables tend to exhibit the greatest agreement in reporting.
}
\examples{
df <- data.frame(
  event_id = c(1, 1, 2, 2, 3),
  actor1 = c("A", "A", "B", "C", "D"),
  deaths_best = c(10, 10, 5, 15, 10)
)
modal_confidence(
  df,
  group_var = "event_id",
  variables = c("actor1", "deaths_best")
)
}
