% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_functions_2d.R
\name{get_clusters}
\alias{get_clusters}
\title{Extracts events from a two-dimensional data stream}
\usage{
get_clusters(
  dat,
  filename = NULL,
  thres = 0.95,
  vis = FALSE,
  epsilon = 5,
  miniPts = 10,
  rolling = TRUE
)
}
\arguments{
\item{dat}{The data matrix}

\item{filename}{If set, the figure of extracted events are saved in this name. The \code{filename} needs to include the correct folder and file name.}

\item{thres}{The cut-off quantile. Default is set to \code{0.95}. Values greater than the quantile will be clustered. The rest is not clustered.}

\item{vis}{If \code{TRUE}, the window data and the extracted events are plotted for a 2D data stream.}

\item{epsilon}{The \code{eps} parameter in \code{dbscan} function in the package \code{dbscan}}

\item{miniPts}{The \code{minPts} parameter in \code{dbscan} function in the package \code{dbscan}}

\item{rolling}{This parameter is set to \code{TRUE} if rolling windows are considered.}
}
\value{
A list with following components
\item{\code{clusters}}{The cluster assignment according to DBSCAN output.}
\item{\code{data}}{The data of this cluster assignment.}
}
\description{
This function extracts events from a two-dimensional (1 spatial x 1 time) data stream.
}
\examples{
out <- gen_stream(2, sd=15)
zz <- as.matrix(out$data)
clst <- get_clusters(zz, vis=TRUE)

}
