% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_functions_2d.R
\name{get_features}
\alias{get_features}
\title{Computes event-features}
\usage{
get_features(
  dat.xyz,
  res.cluster,
  normal.stats.splines,
  win_size = 200,
  tt = 10
)
}
\arguments{
\item{dat.xyz}{The data in a cluster friendly format. The first two columns have \code{y} and \code{x} positions with the third column having the pixel value of that position.}

\item{res.cluster}{Cluster details from \code{dbscan}.}

\item{normal.stats.splines}{The background statistics, output from \code{\link{spline_stats}}.}

\item{win_size}{The window length of the moving window model, default is set to \code{200}.}

\item{tt}{Related to event ages. For example if \code{tt=10} then the event ages are \code{10, 20, 30} and \code{40}.}
}
\value{
An \code{Nx22x4} array  is returned for 2D data streams and an \code{Nx13x4} array for 3D data streams. Here \code{N} is the total number of  events extracted from all windows. The second dimension has \code{m} features and the class label for the \code{supervised} setting.  The third dimension has \code{4} different event ages : \code{tt, 2tt, 3tt, 4tt}.
For example, the element at \code{[10,6,3]} has the 6th feature, of the 10th extracted event when the age of the event is \code{3tt}. The features for 2D streams are listed below. For 3D streams the features \code{cluster_id, pixels, length, width, height, total_value, l2w_ratio, centroid_x, centroid_y, centroid_z, mean, std_dev} and \code{sd_from_global_mean} are computed.
  \item{\code{cluster_id}}{An identification number for each event.}
  \item{\code{pixels}}{The number of pixels of each event.}
  \item{\code{length}}{The length of the event.}
  \item{\code{width}}{The width of the event.}
  \item{\code{total_value}}{The total value of the pixels.}
  \item{\code{l2w_ratio}}{Length to width ratio of event.}
  \item{\code{centroid_x}}{x coordinate of event centroid.}
  \item{\code{centroid_y}}{y coordinate of event centroid.}
  \item{\code{mean}}{Mean value of event pixels.}
  \item{\code{std_dev}}{Standard deviation of event pixels.}
  \item{\code{avg_slope}}{The slope of an \code{lm} object fitted to the event pixels.}
  \item{\code{quad_1}}{The linear coefficient of  a second order polynomial fitted to event pixels using \code{lm}. }
  \item{\code{quad_2}}{The quadratic coefficient of a second order polynomial fitted to event pixels using \code{lm}.}
  \item{\code{2sd_from_mean}}{The proportion of event pixels/cells that has values greater than 2 global standard deviations from the global mean of the window.}
  \item{\code{3sd_from_mean}}{The proportion of event pixels/cells that has values greater than 3 global standard deviations from the global mean of the window.}
  \item{\code{4sd_from_mean}}{The proportion of event pixels/cells that has values greater than 4 global standard deviations from the global mean of the window.}
  \item{\code{5iqr_from_median}}{A small portion of each window and its column medians and column IQRs are used to construct two smoothing splines: a median spline and an IQR spline. The value of the median smoothing spline at each event centroid is used as the local median for that event. Similarly, the value of the IQR smoothing spline at each event centroid is used as the local IQR for that event. This feature gives the proportion of event pixels/cells  that has values greater than 5 local IQRs from the local median.}
  \item{\code{6iqr_from_median}}{The proportion of event pixels/cells that has values greater than 6 local IQRs from the local median computed using splines.}
  \item{\code{7iqr_from_median}}{The proportion of event pixels/cells that has values greater than 7 local IQRs from the local median computed using splines.}
  \item{\code{8iqr_from_median}}{The proportion of event pixels/cells that has values greater than 8 local IQRs from the local median computed using splines.}
  \item{\code{iqr_from_median}}{Let us denote the 75th percentile of the event pixels value by \code{x}. How many local IQRs is \code{x} is away from the local median? Both local IQR and local median are computed using splines. That value is given by this feature. }
  \item{\code{sd_from_mean}}{Let us denote the 80th percentile of the event pixels value by \code{x}. How many global standard deviations is \code{x} is away from the global mean? Here both global values are computed from window data. }
}
\description{
This function computes event features of 2D events.
}
\examples{
out <- gen_stream(1, sd=15)
zz <- as.matrix(out$data)
clst <- get_clusters(zz, vis=TRUE)
sstats <- spline_stats(zz[1:100,])
ftrs <- get_features(clst$data, clst$clusters$cluster, sstats)
}
