% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpdcTrain.R
\name{gpdcTrain}
\alias{gpdcTrain}
\title{GPD Classifier - training}
\usage{
gpdcTrain(train, k)
}
\arguments{
\item{train}{a data matrix containing the train data. Class labels should not be included.}

\item{k}{the number of upper order statistics to be used.}
}
\value{
A list of three elements.
\item{pshapes}{the estimated rescaled shape parameters for each point in the training dataset.}
\item{balls}{the estimated radius for each point in the training dataset.}
\item{k}{the number of upper order statistics used.}
}
\description{
This function is used to train a GPD classifier. It can be used to perform open set classification based on the generalized Pareto distribution.
}
\details{
For details on the method and parameters see Vignotto and Engelke (2018).
}
\note{
Data are not scaled internally; any preprocessing has to be done externally.
}
\examples{
trainset <- LETTER[1:15000,]
knowns <- trainset[trainset$class==1, -1]
gpdClassifier <- gpdcTrain(train = knowns, k = 10)
}
\references{
Vignotto, E., & Engelke, S. (2018). Extreme Value Theory for Open Set Classification-GPD and GEV Classifiers. \emph{arXiv preprint arXiv:1808.09902}.
}
\seealso{
\code{\link{gpdcTest}}
}
\author{
Edoardo Vignotto \cr
\email{edoardo.vignotto@unige.ch}
}
