% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_ewoc.R
\name{ewoc_simulation}
\alias{ewoc_simulation}
\title{EWOC simulation}
\usage{
ewoc_simulation(
  step_zero,
  n_sim,
  sample_size,
  response_sim,
  fixed_first_cohort = TRUE,
  n_cohort = 1,
  alpha_strategy = "conditional",
  alpha_rate = 0.05,
  stop_rule_sim = NULL,
  ncores = 1,
  seed = 1234,
  ...
)
}
\arguments{
\item{step_zero}{an object from the classes either 'ewoc_d1classical' or 'ewoc_d1extended' or
'ewoc_d1ph' created using the first cohort data.}

\item{n_sim}{a number indicating the number of phase I clinical trials
to be simulated.}

\item{sample_size}{a number indicating the number of patients enrolled for
each clinical trial.}

\item{response_sim}{a function which is self-contained and will be used
as a generator function of the response variables in the simulation.
Its only input is 'dose' and output is the indicator of DLT for classical and
extended EWOC and the time until DLT for proportional hazards EWOC.}

\item{fixed_first_cohort}{a logical value indicating if the first cohort
should be randomly generated or be fixed as the input in 'step_zero'.}

\item{n_cohort}{a number indicating the number of patients enrolled at each cohort.
It is only used for 'ewoc_d1classical' and 'ewoc_d1extended'.}

\item{alpha_strategy}{a character indicating the strategy to apply for the
feasibility value. Default is "constant". Options are "increasing" and
"conditional".}

\item{alpha_rate}{a numerical value indicating the rate of the
feasibility strategy. Only necessary if alpha_strategy is either
'increasing' or 'conditional'.}

\item{stop_rule_sim}{a function having as an input an object containing all
the information related to the trial as the returned object trial from either
\code{ewoc_d1classical}, \code{ewoc_d1extended}, \code{ewoc_d1ph} and as
output a logical value indicating the trial should be stopped.}

\item{ncores}{a numeric value indicating the number of cores to be used in the
simulation performed in parallel. Use parallel::detectCores() to check the number of
cores available.}

\item{seed}{is an integer value, containing the random number generator (RNG) state for random number generation.}

\item{...}{For an object \code{step_zero} with class 'ewoc_d1ph',
the argument \code{rate_sim} which controls the rate of accrue of patients following a Poisson process. The default is 1.}
}
\value{
\code{alpha_sim} a matrix \code{n_sim} x \code{sample_size} containing
the values of feasibility used for each step in the trial and each trial in
the simulation.

\code{dlt_sim} a matrix \code{n_sim} x \code{sample_size} containing
ones and zeros indicating the occurrence of DLT (1) and the absence of DLT (0)
for each step in the trial and each trial in the simulation.

\code{dose_sim} a matrix \code{n_sim} x \code{sample_size} containing
the doses assigned for each step in the trial and each trial in the simulation.

\code{mtd_sim} a numeric vector \code{n_sim} x 1 containing
the recommended MTD for each trial in the simulation.

\code{rho_sim} a numeric vector \code{n_sim} x k containing
the estimated rho parameter(s) for each trial in the simulation, where k = 1
for ewoc_d1classical, ewoc_d1ph, and k = 2 for ewoc_d1extended.
}
\description{
Generic function for simulating EWOC trials.
}
\examples{
\dontshow{
### classical EWOC
DLT <- 0
dose <- 20
step_zero <- ewoc_d1classical(DLT ~ dose, type = 'discrete',
                          theta = 0.33, alpha = 0.25,
                          min_dose = 20, max_dose = 100,
                          dose_set = seq(20, 100, 20),
                          rho_prior = matrix(1, ncol = 2, nrow = 1),
                          mtd_prior = matrix(1, ncol = 2, nrow = 1),
                          rounding = "nearest")
response_sim <- response_d1classical(rho = 0.05, mtd = 60, theta = 0.33,
                                 min_dose = 20, max_dose = 100)
sim <- ewoc_simulation(step_zero = step_zero,
                     n_sim = 1, sample_size = 2, n_cohort = 1,
                     alpha_strategy = "conditional",
                     response_sim = response_sim,
                     fixed_first_cohort =  TRUE,
                     ncores = 1)

### Extended EWOC
DLT <- 0
dose <- 20
step_zero <- ewoc_d1extended(DLT ~ dose, type = 'discrete',
                         theta = 0.33, alpha = 0.25,
                         min_dose = 20, max_dose = 100,
                         dose_set = seq(20, 100, 20),
                         rho_prior = matrix(1, ncol = 2, nrow = 2),
                         rounding = "nearest")
response_sim <- response_d1extended(rho = c(0.05, 0.5),
                                 min_dose = 20, max_dose = 100)
sim <- ewoc_simulation(step_zero = step_zero,
                     n_sim = 1, sample_size = 2, n_cohort = 1,
                     alpha_strategy = "conditional",
                     response_sim = response_sim,
                     ncores = 1)

### PH EWOC
time <- 0
status <- 0
dose <- 20

step_zero <- ewoc_d1ph(cbind(time, status) ~ dose, type = 'discrete',
                     theta = 0.33, alpha = 0.25, tau = 10,
                     min_dose = 20, max_dose = 100,
                     dose_set = seq(20, 100, 20),
                     rho_prior = matrix(1, ncol = 2, nrow = 1),
                     mtd_prior = matrix(1, ncol = 2, nrow = 1),
                     distribution = 'exponential',
                     rounding = 'nearest')
response_sim <- response_d1ph(rho = 0.05, mtd = 40, theta = 0.33,
                            min_dose = 20, max_dose = 100,
                            tau = 10, distribution = "exponential")
sim <- ewoc_simulation(step_zero = step_zero,
                     n_sim = 1, sample_size = 2, n_cohort = 1,
                     alpha_strategy = "conditional",
                     response_sim = response_sim,
                     fixed_first_cohort = TRUE,
                     ncores = 1)
}

\dontrun{
### Classical EWOC
DLT <- 0
dose <- 20
step_zero <- ewoc_d1classical(DLT ~ dose, type = 'discrete',
                          theta = 0.33, alpha = 0.25,
                          min_dose = 20, max_dose = 100,
                          dose_set = seq(20, 100, 20),
                          rho_prior = matrix(1, ncol = 2, nrow = 1),
                          mtd_prior = matrix(1, ncol = 2, nrow = 1),
                          rounding = "nearest")
response_sim <- response_d1classical(rho = 0.05, mtd = 60, theta = 0.33,
                                 min_dose = 20, max_dose = 100)
sim <- ewoc_simulation(step_zero = step_zero,
                      n_sim = 2, sample_size = 30, n_cohort = 1,
                      alpha_strategy = "conditional",
                      response_sim = response_sim,
                      ncores = 1)

### Extended EWOC
DLT <- 0
dose <- 20
step_zero <- ewoc_d1extended(DLT ~ dose, type = 'discrete',
                          theta = 0.33, alpha = 0.25,
                          min_dose = 20, max_dose = 100,
                          dose_set = seq(20, 100, 20),
                          rho_prior = matrix(1, ncol = 2, nrow = 2),
                          rounding = "nearest")
response_sim <- response_d1extended(rho = c(0.05, 0.5),
                                  min_dose = 20, max_dose = 100)
sim <- ewoc_simulation(step_zero = step_zero,
                      n_sim = 2, sample_size = 30, n_cohort = 1,
                      alpha_strategy = "conditional",
                      response_sim = response_sim,
                      ncores = 1)

### PH EWOC
time <- 0
status <- 0
dose <- 20

step_zero <- ewoc_d1ph(cbind(time, status) ~ dose, type = 'discrete',
                     theta = 0.33, alpha = 0.25, tau = 10,
                     min_dose = 20, max_dose = 100,
                     dose_set = seq(20, 100, 20),
                     rho_prior = matrix(1, ncol = 2, nrow = 1),
                     mtd_prior = matrix(1, ncol = 2, nrow = 1),
                     distribution = 'exponential',
                     rounding = 'nearest')
response_sim <- response_d1ph(rho = 0.05, mtd = 60, theta = 0.33,
                            min_dose = 20, max_dose = 100,
                            tau = 10, distribution = "exponential")
sim <- ewoc_simulation(step_zero = step_zero,
                      n_sim = 2, sample_size = 30, n_cohort = 1,
                      alpha_strategy = "conditional",
                      response_sim = response_sim,
                      ncores = 1)
}

}
