% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operating_characteristics.R
\name{stop_rule}
\alias{stop_rule}
\title{Evaluation of the stopping rule}
\usage{
stop_rule(dlt_matrix, sample_size, digits = 2)
}
\arguments{
\item{dlt_matrix}{Matrix of the number of DLT for each step of the trial (column)
and for each trial (row).}

\item{sample_size}{a numerical value indicating the expected sample size.}

\item{digits}{a numerical value indicating the number of digits.}
}
\value{
A list consisting of
\itemize{
\item{\code{average}: }{Average number of patients to stop a trial.}
\item{\code{min}: }{Minimum number of patients to stop a trial.}
\item{\code{max}: }{Maximum number of patients to stop a trial.}
\item{\code{nstop}: }{Percent of stopped trials}.
}
}
\description{
Calculate the average, minimum, maximum number of patients to stop a trial and
the percent of stopped trials. Stopped trials contain NA after the last
assigned dose.
}
\examples{
\dontrun{
DLT <- 0
dose <- 20
step_zero <- ewoc_d1classical(DLT ~ dose, type = 'discrete',
                           theta = 0.33, alpha = 0.25,
                           min_dose = 0, max_dose = 100,
                           dose_set = seq(0, 100, 20),
                           rho_prior = matrix(1, ncol = 2, nrow = 1),
                           mtd_prior = matrix(1, ncol = 2, nrow = 1),
                           rounding = "nearest")
stop_rule_sim(step_zero)
response_sim <- response_d1classical(rho = 0.05, mtd = 20, theta = 0.33,
                                  min_dose = 10, max_dose = 50)
sim <- ewoc_simulation(step_zero = step_zero,
                       n_sim = 1, sample_size = 2,
                       alpha_strategy = "increasing",
                       response_sim = response_sim,
                       stop_rule_sim = stop_rule_sim,
                       ncores = 2)
stop_rule(sim$dlt_sim)
}

\dontrun{
DLT <- 0
dose <- 20
step_zero <- ewoc_d1classical(DLT ~ dose, type = 'discrete',
                           theta = 0.33, alpha = 0.25,
                           min_dose = 0, max_dose = 100,
                           dose_set = seq(0, 100, 20),
                           rho_prior = matrix(1, ncol = 2, nrow = 1),
                           mtd_prior = matrix(1, ncol = 2, nrow = 1),
                           rounding = "nearest")
stop_rule_sim(step_zero)
response_sim <- response_d1classical(rho = 0.05, mtd = 20, theta = 0.33,
                                  min_dose = 10, max_dose = 50)
sim <- ewoc_simulation(step_zero = step_zero,
                       n_sim = 2, sample_size = 30,
                       alpha_strategy = "increasing",
                       response_sim = response_sim,
                       stop_rule_sim = stop_rule_sim,
                       ncores = 2)
stop_rule(sim$dlt_sim)
}

}
