% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deidentify.R
\name{deidentify}
\alias{deidentify}
\title{Remove columns that could include identifiable information}
\usage{
deidentify(x, strict = TRUE)
}
\arguments{
\item{x}{Data frame (downloaded from Qualtrics).}

\item{strict}{Logical indicating whether to use strict or non-strict level
of deidentification. Strict removes computer information columns in addition
to IP address and location.}
}
\value{
An object of the same type as \code{x} that excludes Qualtrics columns with
identifiable information.
}
\description{
The \code{deidentify()} function selects out columns from
\href{https://www.qualtrics.com/}{Qualtrics} surveys that may include identifiable
information such as IP address, location, or computer characteristics.
}
\details{
The function offers two levels of deidentification. The default strict level
removes columns associated with IP address and location and computer
information (browser type and version, operating system, and screen
resolution). The non-strict level removes only columns associated with
IP address and location.

Typically, deidentification should be used at the end of a processing pipeline
so that these columns can be used to exclude rows.
}
\examples{
names(qualtrics_numeric)

# Remove IP address, location, and computer information columns
deid <- deidentify(qualtrics_numeric)
names(deid)

# Remove only IP address and location columns
deid2 <- deidentify(qualtrics_numeric, strict = FALSE)
names(deid2)
}
\concept{helper}
