% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_by_NAs.R
\name{split_by_NAs}
\alias{split_by_NAs}
\title{Divides data into parts that contain no missing values}
\usage{
split_by_NAs(x)
}
\arguments{
\item{x}{A vector or matrix.}
}
\value{
A matrix containing a column for each run of non-missing values in
  \code{x}.  The number of rows is equal to the longest run of non-missing
  values in \code{x} and will therefore be at most \code{nrow{x}}.  The
  matrix is padded with \code{NA} values at the end of each column, where
  necessary.

  The returned object has an attribute called \code{split_by_NAs_done}
  whose value is \code{TRUE}, so that in programming one can avoid calling
  \code{split_by_NAs} more than once.
}
\description{
Splits the values in a numeric matrix column-wise into sequences of
non-missing values.
}
\details{
For each column in \code{x}, \code{split_by_NAs} finds runs of
  values that contain no missing values and assigns them to a column in the
  matrix that is returned.  Different columns are treated separately.
  If there are no missing values in a column then that column appears
  unmodified in the output matrix.  Please see the \strong{Examples}
  for illustrations.
}
\examples{
# Create a simple numeric matrix and insert some NAs
x <- matrix(1:50, 10, 5)
x[c(3, 8), 1] <- NA
x[c(1:2, 5, 10), 3] <- NA
x[1:3, 4] <- NA
x[7:10, 5] <- NA
x

res <- split_by_NAs(x)
res

# An example of a character matrix
x <- matrix(c(letters, letters[1:18]), 11, 4)
x[c(1:2, 5:11), 2] <- NA
x[c(2:4, 6:11), 3] <- NA
x[1:10, 4] <- NA

res <- split_by_NAs(x)
res
}
