% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgaps.R
\name{dgaps_stat}
\alias{dgaps_stat}
\title{Sufficient statistics for the left-censored inter-exceedances time model}
\usage{
dgaps_stat(data, u, q_u, D = 1, inc_cens = TRUE)
}
\arguments{
\item{data}{A numeric vector of raw data.  No missing values are allowed.}

\item{u}{A numeric scalar.  Extreme value threshold applied to data.}

\item{q_u}{A numeric scalar.  An estimate of the probability with which
the threshold \code{u} is exceeded.  If \code{q_u} is missing then it is
calculated using \code{mean(data > u, na.rm = TRUE)}.}

\item{D}{A numeric scalar.  Run parameter \eqn{K}, as defined in Suveges and
Davison (2010).  Threshold inter-exceedances times that are not larger
than \code{k} units are assigned to the same cluster, resulting in a
\eqn{K}-gap equal to zero.  Specifically, the \eqn{K}-gap \eqn{S}
corresponding to an inter-exceedance time of \eqn{T} is given by
\eqn{S = \max(T - K, 0)}{S = max(T - K, 0)}.}

\item{inc_cens}{A logical scalar indicating whether or not to include
contributions from right-censored inter-exceedance times relating to the
first and last observation.  It is known that these times are greater
than or equal to the time observed. See Attalides (2015) for details.}
}
\value{
A list containing the sufficient statistics, with components
    \item{\code{N0} }{the number of left-censored inter-exceedance times.}
    \item{\code{N1} }{contribution from inter-exceedance times that are not
      left-censored (see \strong{Details}).}
    \item{\code{sum_qtd} }{the sum of the (scaled) inter-exceedance times
      that are not left-censored, that is,
      \eqn{q (I_0 T_0 + \cdots + I_N T_N)}{q (I_0 T_0 + ... + I_N T_N)},
      where \eqn{q} is estimated by the proportion of threshold
      exceedances.}
    \item{\code{n_dgaps} }{the number of inter-exceedances that contribute
      to the log-likelihood.}
    \item{\code{q_u} }{the sample proportion of values that exceed the
      threshold.}
    \item{\code{D} }{the input value of \code{D}.}
}
\description{
Calculates sufficient statistics for the the left-censored inter-exceedances
time \eqn{D}-gaps model for the extremal index \eqn{\theta}.
}
\details{
The sample inter-exceedance times are
  \eqn{T_0, T_1, ..., T_{N-1}, T_N}{T_0, T_1, ..., T_(N-1), T_N},
  where \eqn{T_1, ..., T_{N-1}}{T_1, ..., T_(N-1)} are uncensored and
  \eqn{T_0} and \eqn{T_N} are right-censored.  Under the assumption that the
  inter-exceedance times are independent, the log-likelihood of the
  \eqn{D}-gaps model is given by
  \deqn{l(\theta; T_0, \ldots, T_N) = N_0 \log(1 - \theta e^{-\theta d}) +
    2 N_1 \log \theta - \theta q (I_0 T_0 + \cdots + I_N T_N),}{%
    l(\theta; T_0, ..., T_N) = N_0 log(1 - exp(-\theta d)) +
    2 N_1 log \theta - \theta q (I_0 T_0 + ... + I_N T_N),}
   where
    \itemize{
      \item \eqn{q} is the threshold exceedance probability, estimated by
        the proportion of threshold exceedances,
      \item \eqn{d = q D},
      \item \eqn{I_j = 1} if \eqn{T_j > D} and \eqn{I_j = 0} otherwise,
      \item \eqn{N_0} is the number of sample inter-exceedance times that
        are left-censored, that is, are less than or equal to \eqn{D},
      \item (apart from an adjustment for the contributions of \eqn{T_0} and
        \eqn{T_N}) \eqn{N_1} is the number of inter-exceedance times that
        are uncensored, that is, are greater than \eqn{D},
      \item specifically, if \code{inc_cens = TRUE} then \eqn{N_1} is equal
        to the number of \eqn{T_1, ..., T_{N-1}}{T_1, ..., T_(N-1)} that are
        uncensored plus \eqn{(I_0 + I_N) / 2}.
    }
   The differing treatment of uncensored and censored \eqn{K}-gaps reflects
   differing contributions to the likelihood. Right-censored
   inter-exceedance times whose observed values are less than or equal to
   \eqn{D} add no information to the likelihood because we do not know to
   which part of the likelihood they should contribute.

   If \eqn{N_1 = 0} then we are in the degenerate case where there is one
   cluster (all inter-exceedance times are left-censored) and the likelihood
   is maximized at \eqn{\theta = 0}.

   If \eqn{N_0 = 0} then all exceedances occur singly (no inter-exceedance
   times are left-censored) and the likelihood is maximized at
   \eqn{\theta = 1}.
}
\examples{
u <- quantile(newlyn, probs = 0.90)
dgaps_stat(newlyn, u = u, D = 1)
}
\references{
Holesovsky, J. and Fusek, M. Estimation of the extremal index
  using censored distributions. Extremes 23, 197-213 (2020).
  \doi{10.1007/s10687-020-00374-3}

Attalides, N. (2015) Threshold-based extreme value modelling,
  PhD thesis, University College London.
  \url{https://discovery.ucl.ac.uk/1471121/1/Nicolas_Attalides_Thesis.pdf}
}
\seealso{
\code{\link{dgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{D}-gaps model.
}
