% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{eTrim}
\alias{eTrim}
\title{Remove padded rows from matrix X}
\usage{
eTrim(X, pad = NA)
}
\arguments{
\item{X}{R object coercible to matrix}

\item{pad}{Value representing padded elements.  By
default it is NA, but could be any value.}
}
\value{
A matrix.
}
\description{
Remove padded rows from matrix X
}
\examples{
n <- 10
x <- rnorm(n)    # x vector
X <- eLag(x,0:1) # X matrix
t <- 1:n         # time vector
T <- eLag(t,0:1) # time matrix; the column corresponding
                 # to 0 is the time for each row,
                 # even after trimming
matplot(X,type="l",lty=1)
X <- eTrim(X)
T <- eTrim(T)
matplot(x=T[,1],y=X,type="l",lty=1,
  xlab="Time")
}

