% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/masslm.R
\name{masslm}
\alias{masslm}
\title{Mass Linear Regression}
\usage{
masslm(data, dv.var, ignore = NULL, p.round = TRUE, c.round = TRUE)
}
\arguments{
\item{data}{data.frame object that contains both the dependent variable and predictor variables you want to regress.}

\item{dv.var}{single dependent variable you want to regress your predictors on.}

\item{ignore}{accepts a character vector of one or more variables you want the function to skip.  If nothing is passed through this option, the function will attempt to run a regression between the dependent variable and every other column of data.}

\item{p.round}{set to TRUE by default.  If left TRUE, will round off the P.value outputs to their 6 significant digits.  Can be a problem for numbers larger than 999999, set to false to return the raw number.}

\item{c.round}{set to TRUE by default.  If left TRUE, will round off the Coefficient outputs to their 6 significant digits.  Can be a problem for numbers larger than 999999, set to false to return the raw number.}
}
\value{
data.frame containing three columns of data, IV, Coefficient, and P.Value.  If one of the columns of data not excluded from the function contained character type data, the function will print an error recommending the user attempt to convert the variable to a factor.
}
\description{
This function takes in a dataframe, the dependent variable, and optionally a character vector of independent variables you want the function to ignore.  It then produces a dataframe of regression results.
}
\examples{
exam.df <- iris
masslm(exam.df, "Sepal.Width", ignore = "Species")
masslm(exam.df, "Sepal.Width", ignore = c("Species", "Petal.Width"))
}

