% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/values2labels.R
\name{values2labels}
\alias{values2labels}
\alias{v2l}
\title{Replace vector/matrix/data.frame/list values with corresponding value labels.}
\usage{
values2labels(x)

v2l(x)
}
\arguments{
\item{x}{vector/matrix/data.frame/list}
}
\value{
Object of the same form as x but with value labels instead of values.
}
\description{
\code{values2labels} replaces vector/matrix/data.frame/list values with
corresponding value labels. If there are no labels for some values they are
converted to characters in most cases. If there are no labels at all for
variable it remains unchanged. \code{v2l} is just shortcut to \code{values2labels}.
}
\examples{
data(mtcars)
var_lab(mtcars$mpg) = NULL
val_lab(mtcars$am) = c(" automatic" = 0, " manual" =  1)

summary(lm(mpg ~ ., data = values2labels(mtcars[,c("mpg","am")])))
}
\seealso{
\link{names2labels}, \link{val_lab},  \link{var_lab}
}
