% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortexp.R
\docType{data}
\name{mortexp}
\alias{mortexp}
\title{Mortality experience study}
\format{
A \code{\link[=data.frame]{data.frame()}} with over 175,000 rows and 24 columns:

\describe{
\item{\code{AS_OF_DATE}}{
This indicates which point in time a record encompasses.
}
\item{\code{POLICY_HOLDER}}{
An index used to distinguish policyholders. In this example the
policyholder is also the (only) insured.
}
\item{
\code{GENDER},
\code{SMOKING_STATUS},
\code{UNDERWRITING_CLASS},
\code{INSURED_DOB},
\code{ISSUE_DATE},
\code{ISSUE_AGE}
}{
Various characteristics of an insured at time of issue.
}
\item{\code{FACE_AMOUNT}}{
Face amount of insurance for a corresponding policy.
}
\item{\code{TERMINATION_DATE}}{
If terminated, the effective date of termination. An \code{NA} value will be
listed for policies that are still in-force.
}
\item{\code{ATTAINED_AGE}}{
The age of the insured at the record's \code{AS_OF_DATE}
}
\item{\code{EXPECTED_MORTALITY_RT}}{
An expected mortality rate for an insured. The rate is calculated
according to De Moivre's Law (also known as uniform distribution of
deaths, or \eqn{\text{UDD}}) with \eqn{\omega=120}.
}
\item{\code{POLICY_DURATION_MNTH}, \code{POLICY_DURATION_YR}}{
Temporal indices describing how long a policy has been in-force at the
\code{AS_OF_DATE}. For example, when a policy is first issued (i.e.,
\eqn{t=0}), it is in policy duration year one and policy duration month
one.
}
\item{\code{POLICY_STATUS}}{
The current status of the policy, either in-force, surrendered, or
death. The value will be listed for each policy record even though a
decrement only occurs at the end of the policy's duration (for policies
which are no longer in-force).
}
\item{\code{MORT_EXPOSURE_CNT},\code{MORT_EXPOSURE_AMT}}{
Measures how many policyholders or how much face amount of insurance is
exposed to the risk of decrement for an associated observations.
}
\item{\code{MORT_ACTUAL_CNT},\code{MORT_ACTUAL_AMT}}{
Measures the decrement occurrence on a policy count or face amount of
insurance basis.
}
\item{\code{MORT_EXPECTED_CNT},\code{MORT_EXPECTED_AMT}}{
Measures the expected decrement value for an associated observation on a
policy count or face amount of insurance basis.
}
\item{\code{MORT_VARIANCE_CNT},\code{MORT_VARIANCE_AMT}}{
Measures the variance of the decrement expectation, also on a policy
count or face amount of insurance basis. Used to calculate credibility
scores and confidence intervals.
}
}
}
\source{
All policy record detail is randomly generated. See
\href{https://www.soa.org/globalassets/assets/Files/Research/2016-10-experience-study-calculations.pdf}{the Society of Actuaries' publication on experience study calculations}
for additional information regarding experience study calculations.
}
\usage{
mortexp
}
\description{
A dataset containing an example of a mortality experience study for 1000
fictional whole life insurance policyholders.
}
\keyword{datasets}
