% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_metrics.R
\name{mutate_metrics}
\alias{mutate_metrics}
\title{Add common metrics to an experience study}
\usage{
mutate_metrics(
  .data,
  measure_sets = guess_measure_sets(.data),
  metrics = list(AVG_OBSRV = avg_observed, AVG_EXPEC = avg_expected, CI_FCTR = ci_fctr,
    AE_RATIO = ae_ratio, CREDIBILITY = credibility),
  ...,
  .by = NULL,
  .keep = c("all", "used", "unused", "none"),
  .before = NULL,
  .after = NULL
)
}
\arguments{
\item{.data}{A \code{\link[base:data.frame]{base::data.frame()}} that houses an experience study.}

\item{measure_sets}{A (potentially named) list of measure sets. Only need to specify once if
chaining multiple \code{expstudy} functions as the \code{measure_sets} will be
passed as an attribute in results.}

\item{metrics}{A named list of functions to calculate \link{metrics}. Each function will be
applied to each set identified in \code{measure_sets}.}

\item{...}{Additional (optional) arguments passed along to each
(metric function)\link{metrics}.}

\item{.by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.keep}{Control which columns from \code{.data} are retained in the output. Grouping
columns and columns created by \code{...} are always kept.
\itemize{
\item \code{"all"} retains all columns from \code{.data}. This is the default.
\item \code{"used"} retains only the columns used in \code{...} to create new
columns. This is useful for checking your work, as it displays inputs
and outputs side-by-side.
\item \code{"unused"} retains only the columns \emph{not} used in \code{...} to create new
columns. This is useful if you generate new columns, but no longer need
the columns used to generate them.
\item \code{"none"} doesn't retain any extra columns from \code{.data}. Only the grouping
variables and columns created by \code{...} are kept.
}}

\item{.before, .after}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, control where new columns
should appear (the default is to add to the right hand side). See
\code{\link[dplyr:relocate]{relocate()}} for more details.}
}
\value{
An object of the same type as \code{.data}. The output has the following
properties:
\itemize{
\item Columns from \code{.data} will be preserved according to the \code{.keep} argument.
\item Existing columns that are modified by \code{...} will always be returned in
their original location.
\item New columns created through \code{...} will be placed according to the
\code{.before} and \code{.after} arguments.
\item The number of rows is not affected.
\item Columns given the value \code{NULL} will be removed.
\item Groups will be recomputed if a grouping variable is mutated.
\item Data frame attributes are preserved.
}
}
\description{
\code{mutate_metrics()} calculates metrics for an experience study using common
measures associated with the data. These measures are identified via the
\code{measure_sets} argument which can be provided directly or be guessed using
regular expressions (\code{regexs}). See \code{\link[=guess_measure_sets]{guess_measure_sets()}} for additional
detail on how this guessing is implemented.
}
\details{
This function is structured in a way that uses sets of measures within the
study as the first function argument of each metric function. The default
argument uses a set of metric functions, provided by \code{expstudy}, which are
commonly requested metrics used in actuarial analyses. For convenience,
a vectorized version of these default metric functions have also been
provided; see \link{metrics} for more information.
}
\section{Naming convention}{


\code{expstudy} uses a naming convention where some functions are prefixed by the
underling \code{dplyr} verb. The purpose of this is to associate the resulting
structure of the \code{expstudy} function with a very similar output as what the
\code{dplyr} function would produce. Note that the intention here is not replace
all \code{dplyr} use cases but instead add specific functionality to streamline
routine experience study analyses.
}

\examples{
# Metrics can be added at a seriatim level, but often are
# calculated after some aggregation is applied to a cohort:
mortexp |>
  dplyr::group_by(
    GENDER
  ) |>
  summarise_measures() |>
  mutate_metrics()

}
