% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_measures.R
\name{summarise_measures}
\alias{summarise_measures}
\title{Aggregate an experience study}
\usage{
summarise_measures(
  .data,
  measure_sets = guess_measure_sets(.data),
  na.rm = TRUE,
  .groups = "drop",
  .by = NULL
)
}
\arguments{
\item{.data}{A \code{\link[base:data.frame]{base::data.frame()}} that houses an experience study.}

\item{measure_sets}{A (potentially named) list of measure sets. Only need to specify once if
chaining multiple \code{expstudy} functions as the \code{measure_sets} will be
passed as an attribute in results.}

\item{na.rm}{logical.  Should missing values (including \code{NaN}) be
    removed?}

\item{.groups}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Grouping structure of the
result.
\itemize{
\item "drop_last": dropping the last level of grouping. This was the
only supported option before version 1.0.0.
\item "drop": All levels of grouping are dropped.
\item "keep": Same grouping structure as \code{.data}.
\item "rowwise": Each row is its own group.
}

When \code{.groups} is not specified, it is chosen
based on the number of rows of the results:
\itemize{
\item If all the results have 1 row, you get "drop_last".
\item If the number of rows varies, you get "keep" (note that returning a
variable number of rows was deprecated in favor of \code{\link[dplyr:reframe]{reframe()}}, which
also unconditionally drops all levels of grouping).
}

In addition, a message informs you of that choice, unless the result is ungrouped,
the option "dplyr.summarise.inform" is set to \code{FALSE},
or when \code{summarise()} is called from a function in a package.}

\item{.by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}
}
\value{
An object \emph{usually} of the same type as \code{.data}.
\itemize{
\item The rows come from the underlying \code{\link[dplyr:group_keys]{group_keys()}}.
\item The columns are a combination of the grouping keys and the summary
expressions that you provide.
\item The grouping structure is controlled by the \verb{.groups=} argument, the
output may be another \link[dplyr]{grouped_df}, a \link[dplyr]{tibble} or a \link[dplyr]{rowwise} data frame.
\item Data frame attributes are \strong{not} preserved, because \code{summarise()}
fundamentally creates a new data frame.
}
}
\description{
\code{summarise_measures()} functions the same as \code{\link[dplyr:summarise]{dplyr::summarise()}} and
returns a new data frame per combination of grouping variable. However,
this function is is streamlined to return the sum of an experience study's
measures instead of any arbitrary summary function. These measures are
identified via the \code{measure_sets} argument which can be provided directly
or be guessed using regular expressions (\code{regexs}). See
\code{\link[=guess_measure_sets]{guess_measure_sets()}} for additional detail on how this guessing is
implemented.
}
\section{Naming convention}{


\code{expstudy} uses a naming convention where some functions are prefixed by the
underling \code{dplyr} verb. The purpose of this is to associate the resulting
structure of the \code{expstudy} function with a very similar output as what the
\code{dplyr} function would produce. Note that the intention here is not replace
all \code{dplyr} use cases but instead add specific functionality to streamline
routine experience study analyses.
}

\examples{
mortexp |>
  dplyr::group_by(
    UNDERWRITING_CLASS
  ) |>
  summarise_measures()
}
