% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixDur.R
\name{fixDur}
\alias{fixDur}
\title{Fixation Duration}
\usage{
fixDur(data, fixTime, passes, AOI = NULL)
}
\arguments{
\item{data}{A data frame containing fixation information of an eye tracing 
experiment and the coded passes. Each row indicates a fixation.}

\item{fixTime}{The name or number of the column containing the time per fixation.}

\item{passes}{The name or number of the column containing the coded passes.}

\item{AOI}{The name or number of the column in \code{data} containing the name
of the area of interest (AOI) that was fixated.}
}
\value{
A data frame with the following columns  
 If the AOI column is provided to \code{passes}:  
  $AOI: containing the AOI names  
  $duration: containing the aggregated durations  
 
 If the passes column is provided to \code{passes} and there is no rereading:  
  $AOI: containing the AOI names  
  $FirstPass: containing the aggregated first pass durations  
  $SecondPass: containing the aggregated second pass durations  
  
 If the passes column is provided to \code{passes} and there is rereading:  
 $AOI: containing the AOI names  
  $FirstPassForward: containing the aggregated first pass forward durations  
  $FirstPassRereading: containing the aggregated first pass rereading durations  
  $SecondPass: containing the aggregated second pass durations  
  
  The result will be in the same unit as the duration input.
  
  If the data contains fixations that were outside the AOI, the first line of 
  the results will contain the total fixation duration outside the AOI's.
}
\description{
Calculates the fixation durations for the passes (Hyönä, Lorch, 
  and Rinck, 2003; Hyönä, and Lorch, 2004) or the AOI's
}
\details{
This function is a wrapper for  \code{\link[stats]{aggregate}} 
  
  The function will only return the fixation duration of the values in the 
  \code{passes} column. The passes column is the vector returned by the 
  \code{link{codePasses}} function. It is also possible to provide the column 
  name of the column containing the AOI's if you require the fixation durations 
  for the AOI's only.
  The column of which the name or number is passed to \code{passes},will be 
  converted to a factor if it is not yet the case.
  
  You can provide the names of the AOI's to \code{AOI_label} and indicate if 
  rereading passes were coded in \code{rereading}. This ensures that the output 
  contains all types of passes for each AOI, even if they did not occur. In 
  that case the value in the output will be 0.
}
\examples{
  data( SimData )
                         
  ### This function compiles fixation durations
  ## for first and second passes
  # when the column name is given
  fixDur( data = SimData, fixTime = "fixTime", 
          passes = "passes" )
          
  # and when column number is given
  fixDur( data = SimData, fixTime = 8, passes = 9 )
  
  ## for forward and rereading passes
  fixDur( data = SimData, fixTime = "fixTime",
          passes = "passesReread" )
          
  ## and for AOI's
  fixDur( data = SimData, fixTime = "fixTime", 
          passes = "AOI" )

}
\references{
Hyönä, J., Lorch, R. F., & Rinck, M. (2003). Eye movement measures to study 
  global text processing. In J. Hyönä, R. Radach, & H. Deubel (Eds.), \emph{The mind's 
  eye: cognitive and applied aspects of eye movement research} (pp. 313-334). 
  Amsterdam: Elsevier Science.  
    
  Hyönä, J., & Lorch, R. F. (2004). Effects of topic headings on text processing: 
  evidence from adult readers’ eye fixation patterns. \emph{Learning and Instruction, 
  14}, 131-152. doi:10.1016/j.learninstruc.2004.01.001
}
\seealso{
\code{\link[stats]{aggregate}}, \code{\link[base]{by}}, 
  \code{\link[base]{tapply}}
}
