% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORGANISE__functions.R
\name{organise.message.markup}
\alias{organise.message.markup}
\title{Markup trial messages.}
\usage{
organise.message.markup(
  message_df,
  fixreport_df,
  message,
  show_working = FALSE
)
}
\arguments{
\item{message_df}{Message report}

\item{fixreport_df}{Fixation report}

\item{message}{The message or event you want to mark up}

\item{show_working}{Should eyeTrackR show more detail when calculating the output?}
}
\value{
An updated fixation report with the message marked up into each trial.
If there is a difference between the number of input and output rows, there was a problem
with the joining of your data. You'll have a repeated session name or trial index.
}
\description{
Markup trial messages.
}
\examples{
data(fixationreport)
data(messagereport)

# REPLACE SPACES IN MESSAGES
messagereport <- organise.message.replace_spaces(messagereport)

# TAKE A LOOK
print(organise.message.descriptives(messagereport))

# MARKUP
fixationreport <- organise.message.markup(message_df=messagereport, 
    fixreport_df = fixationreport, message="DISPLAY_START")

fixationreport <- organise.message.markup(message_df=messagereport, 
    fixreport_df = fixationreport, message="DISPLAY_CHANGE")
}
