% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{frlr2}
\alias{frlr2}
\title{Fit Repeated Linear Regressions with Two Variables}
\usage{
frlr2(R_X, R_idx1, R_idx2, R_Y, R_COV, num_threads = -1L)
}
\arguments{
\item{R_X}{the observation matrix}

\item{R_idx1}{the first identical feature}

\item{R_idx2}{the second identical feature}

\item{R_Y}{the response variable}

\item{R_COV}{common variables}

\item{num_threads}{number of threads for openmp. If it is -1 (default), it will use all possible threads.}
}
\value{
the fitting results for each regression.
}
\description{
Fit a set of linear regressions which differ only in two variables.
}
\examples{
set.seed(123)
X = matrix(rnorm(50), 10, 5)
Y = rnorm(10)
COV = matrix(rnorm(40), 10, 4)
idx1 = c(1, 2, 3, 4, 1, 1, 1, 2, 2, 3)
idx2 = c(2, 3, 4, 5, 3, 4, 5, 4, 5, 5)
frlr2(X, idx1, idx2, Y, COV)
}
