% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{interpolate.model_mean}
\alias{interpolate.model_mean}
\title{Interpolate missing values from a fable model}
\usage{
\method{interpolate}{model_mean}(object, new_data, specials, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{new_data}{A tsibble containing the time points and exogenous regressors to produce forecasts for.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{...}{Other arguments passed to methods}
}
\value{
A tibble of the same dimension of \code{new_data} with missing values interpolated.
}
\description{
Applies a model-specific estimation technique to predict the values of missing values in a \code{tsibble}, and replace them.
}
\examples{
library(tsibbledata)

olympic_running \%>\%
  model(mean = MEAN(Time)) \%>\%
  interpolate(olympic_running)
}
