% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portVaRDecomp.R
\name{portVaRDecomp}
\alias{portVaRDecomp}
\alias{portVaRDecomp.ffm}
\title{Decompose portfolio VaR into individual factor contributions}
\usage{
portVaRDecomp(object, ...)

\method{portVaRDecomp}{ffm}(
  object,
  weights = NULL,
  factor.cov,
  p = 0.05,
  type = c("np", "normal"),
  invert = FALSE,
  ...
)
}
\arguments{
\item{object}{fit object of class \code{tsfm}, or \code{ffm}.}

\item{...}{other optional arguments passed to \code{\link[stats]{quantile}} and 
optional arguments passed to \code{\link[stats]{cov}}}

\item{weights}{a vector of weights of the assets in the portfolio. Default is NULL, 
in which case an equal weights will be used.}

\item{factor.cov}{optional user specified factor covariance matrix with 
named columns; defaults to the sample covariance matrix.}

\item{p}{tail probability for calculation. Default is 0.05.}

\item{type}{one of "np" (non-parametric) or "normal" for calculating VaR. 
Default is "np".}

\item{invert}{a logical variable to choose if change VaR to positive number, default
is False}
}
\value{
A list containing 
\item{portVaR}{factor model VaR of portfolio return.}
\item{n.exceed}{number of observations beyond VaR.}
\item{idx.exceed}{a numeric vector of index values of exceedances.}
\item{mVaR}{length-(K + 1) vector of marginal contributions to VaR.}
\item{cVaR}{length-(K + 1) vector of component contributions to VaR.}
\item{pcVaR}{length-(K + 1) vector of percentage component contributions to VaR.}
Where, K is the number of factors.
}
\description{
Compute the factor contributions to Value-at-Risk (VaR) of 
portfolio returns based on Euler's theorem, given the fitted factor model. 
The partial derivative of VaR w.r.t. factor beta is computed as the expected 
factor return given portfolio return is equal to its VaR and approximated by a
kernel estimator. Option to choose between non-parametric and Normal.
}
\details{
The factor model for a portfolio's return at time \code{t} has the 
form \cr \cr \code{R(t) = beta'f(t) + e(t) = beta.star'f.star(t)} \cr \cr 
where, \code{beta.star=(beta,sig.e)} and \code{f.star(t)=[f(t)',z(t)]'}. By 
Euler's theorem, the VaR of the asset's return is given by: 
\cr \cr \code{VaR.fm = sum(cVaR_k) = sum(beta.star_k*mVaR_k)} \cr \cr 
where, summation is across the \code{K} factors and the residual, 
\code{cVaR} and \code{mVaR} are the component and marginal 
contributions to \code{VaR} respectively. The marginal contribution to VaR 
is defined as the expectation of \code{F.star}, conditional on the loss 
being equal to \code{portVaR}. This is approximated as described in 
Epperlein & Smillie (2006); a triangular smoothing kernel is used here.
}
\seealso{
\code{\link{fitFfm}}
for the different factor model fitting functions.

\code{\link{portSdDecomp}} for factor model Sd decomposition.
\code{\link{portEsDecomp}} for factor model ES decomposition.
}
\author{
Douglas Martin, Lingjie Yi
}
