% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskDecomp.R
\name{riskDecomp.ffm}
\alias{riskDecomp.ffm}
\title{Decompose Risk into individual factor contributions}
\usage{
riskDecomp.ffm(
  object,
  risk,
  weights = NULL,
  portDecomp = TRUE,
  factor.cov,
  p = 0.05,
  type = c("np", "normal"),
  invert = FALSE,
  ...
)
}
\arguments{
\item{object}{fit object of class \code{tsfm}, or \code{ffm}.}

\item{risk}{one of "Sd" (Standard Deviation) or "VaR" (Value at Risk) or "ES" (Expected Shortfall)}

\item{weights}{a vector of weights of the assets in the portfolio, names of 
the vector should match with asset names. Default is NULL, in which case an 
equal weights will be used.}

\item{portDecomp}{logical. If \code{True} the decomposition of risk is done for the portfolio based on the weights.
Else, the decomposition of risk is done for each asset. \code{Default} is \code{TRUE}}

\item{factor.cov}{optional user specified factor covariance matrix with 
named columns; defaults to the sample covariance matrix.}

\item{p}{tail probability for calculation. Default is 0.05.}

\item{type}{one of "np" (non-parametric) or "normal" for calculating Es. 
Default is "np".}

\item{invert}{a logical variable to choose if change ES to positive number, default
is False}

\item{...}{other optional arguments passed to \code{\link[stats]{quantile}} and 
optional arguments passed to \code{\link[stats]{cov}}}
}
\value{
A list containing 
\item{portES}{factor model ES of portfolio returns.}
\item{mES}{length-(K + 1) vector of marginal contributions to Es.}
\item{cES}{length-(K + 1) vector of component contributions to Es.}
\item{pcES}{length-(K + 1) vector of percentage component contributions to Es.}
Where, K is the number of factors.
}
\description{
Compute the factor contributions to Sd, VaR and ES of returns based on Euler's theorem, given 
the fitted factor model.
}
\seealso{
\code{\link{fitFfm}}
for the different factor model fitting functions.

\code{\link{portSdDecomp}} for factor model Sd decomposition.
\code{\link{portVaRDecomp}} for factor model VaR decomposition.
}
\author{
Eric Zivot, Yi-An Chen, Sangeetha Srinivasan, Lingjie Yi and Avinash Acharya
}
