% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fake_transport.R
\name{fake_survey_people}
\alias{fake_survey_people}
\alias{fake_sondage_people}
\alias{fake_survey_answers}
\alias{fake_sondage_answers}
\title{Base transport}
\usage{
fake_survey_people(n, seed = 2811, local = c("fr_FR"))

fake_sondage_people(...)

fake_survey_answers(n = 200, x, seed = 2811, split = FALSE, local = c("fr_FR"))

fake_sondage_answers(...)
}
\arguments{
\item{n}{Number of sondage}

\item{seed}{fixe la graine aleatoire}

\item{local}{the local of the base. Currently supported : "fr_FR" and "en_US".}

\item{x}{Optionnal. fake client data base with "age" column}

\item{split}{Logical. Split database in individuals and answers}
}
\value{
A dataframe of fake result from a .
}
\description{
Base transport

Create fake transport sondage
}
\details{
\itemize{
  \item id_individu Unique identification of people with "ID-AAAA-1111" pattern
  \item sexe. sex. c("F" = "Female", "M" = "Male", "O" = "Other"). Some are missing
  \item age age. Some are missing
  \item region. some regions have NA values that may be fill with left_join with fra_sf dataset. Some regions are more represented than others
  \item id_departement. number identifying French department
  \item nom_departement. Name of the department. Some departement have NA values that may be fill using id_departement.
  \item question_date. Date/hour when questionnaire has been answered.
  \item year. year extracted from question_date
}

\itemize{
  \item 3 types for each individuals: travail, commerces, loisirs
  \item distance_km. Average distance (km) to target location. Distance is related to age.
  \item transport. Mean of transport to go to target location. Depends on distance.
  \item time_travel_hours. Average duration (hours) to target location. Depends on distance and transport.
}
}
\examples{
fake_survey_people(10)
answers <- fake_sondage_answers()
if (FALSE){
ggplot(answers) +
  aes(age, log(distance_km), colour = type) +
  geom_point() +
  geom_smooth() +
  facet_wrap(~type, scales = "free_y")
}

}
\keyword{internal}
