% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMatches.R
\name{getMatches}
\alias{getMatches}
\title{getMatches}
\usage{
getMatches(dfA, dfB, fl.out, threshold.match, combine.dfs)
}
\arguments{
\item{dfA}{Dataset A - matched to Dataset B by \code{fastLink()}.}

\item{dfB}{Dataset B - matches to Dataset A by \code{fastLink()}.}

\item{fl.out}{Either the output from \code{fastLink()} or \code{matchesLink()}.}

\item{threshold.match}{A number between 0 and 1 indicating the lower bound that the
user wants to declare a match. For instance, threshold.match = .85 will return all pairs with posterior probability greater than .85 as matches.
Default is 0.85.}

\item{combine.dfs}{Whether to combine the two data frames being merged into a single data frame. If FALSE, two data frames are returned in a list. Default is TRUE.}
}
\value{
\code{getMatches()} returns a list of two data frames:
\item{dfA.match}{A subset of \code{dfA} subsetted down to the successful matches.}
\item{dfB.match}{A subset of \code{dfB} subsetted down to the successful matches.}
}
\description{
Subset two data frames to the matches returned by \code{fastLink()}
or \code{matchesLink()}. Can also return a single deduped data frame
if dfA and dfB are identical and fl.out is of class 'fastLink.dedupe'.
}
\examples{
\dontrun{
fl.out <- fastLink(dfA, dfB,
varnames = c("firstname", "lastname", "streetname", "birthyear"),
n.cores = 1)
ret <- getMatches(dfA, dfB, fl.out)
}
}
\author{
Ben Fifield  <benfifield@gmail.com>
}
