% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Pallets}
\alias{Pallets}
\title{Pallet repair data}
\format{
A data frame with 20 observations on the following 3 variables.
\describe{ 
\item{pallets}{ number of pallets repaired}
\item{employee}{ a factor with levels \code{A} \code{B} \code{C}
\code{D}} 
\item{day}{ a factor with levels \code{day1} \code{day2}
\code{day3} \code{day4} \code{day5}} }
}
\source{
Michael Stob, Calvin College
}
\description{
The paletts data set contains data from a firm that recycles paletts.
Paletts from warehouses are bought, repaired, and resold. (Repairing a
palette typically involves replacing one or two boards.) The company has
four employees who do the repairs. The employer sampled five days for each
employee and recorded the number of pallets repaired.
}
\examples{

data(Pallets)
# Do the employees differ in the rate at which they repair pallets?
pal.lm1 <- lm(pallets ~ employee, data = Pallets) 
anova(pal.lm1)
# Now using day as a blocking variable
pal.lm2 <- lm(pallets ~ employee + day, data = Pallets) 
anova(pal.lm2)
gf_line(pallets ~ day, data = Pallets,
		group = ~employee,
		color = ~employee) \%>\%
  gf_point() \%>\%
  gf_labs(title = "Productivity by day and employee")

}
\keyword{datasets}
