% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kqr-methods.R
\name{coef.kqr}
\alias{coef.kqr}
\title{Extract model coefficients from a `kqr` object.}
\usage{
\method{coef}{kqr}(object, s = NULL, ...)
}
\arguments{
\item{object}{Fitted [kqr()] object.}

\item{s}{Value(s) of the penalty parameter `lambda` at which
coefficients are required. Default is the entire sequence.}

\item{...}{Not used.}
}
\value{
The coefficients at the requested values for `lambda`.
}
\description{
Computes the coefficients at the requested value(s) for `lambda` from a
[kqr()] object.
}
\details{
`s` is the new vector of `lambda` values at which predictions are requested.
If `s` is not in the lambda sequence used for fitting the model, the `coef`
function will use linear interpolation to make predictions. The new values
are interpolated using a fraction of coefficients from both left and right
`lambda` indices.
}
\examples{
library(MASS)
data(GAGurine)
x <- as.matrix(GAGurine$Age)
y <- GAGurine$GAG
lambda <- 10^(seq(1, -4, length.out=10))
fit <- kqr(x, y, lambda=lambda, tau=0.1)
coef(fit)
}
\seealso{
[kqr()] and [predict.kqr()].
}
