% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi.R
\name{mi}
\alias{mi}
\title{kNN Mutual Information Estimators}
\usage{
mi(x, y, k = 5, distance = FALSE)
}
\arguments{
\item{x}{A numeric vector, matrix, data.frame or \code{\link{dist}} object.}

\item{y}{A numeric vector, matrix, data.frame or \code{\link{dist}} object.}

\item{k}{Order of neighborhood to be used in the kNN method.}

\item{distance}{Bool flag for considering \code{x} and \code{y} as distance matrices or not.
If \code{distance = TRUE}, \code{x} and \code{y} would be considered as distance matrices,
otherwise, these arguments are treated as data and
Euclidean distance would be implemented for the samples in \code{x} and \code{y}.
Default: \code{distance = FALSE}.}
}
\value{
\item{\code{mi}}{The estimated mutual information.}
}
\description{
Estimate mutual information based on the distribution of
nearest neighborhood distances. The kNN method is described by Kraskov, et. al (2004).
}
\details{
If two samples are passed to arguments \code{x} and \code{y}, the sample sizes
(i.e. number of rows of the matrix or length of the vector) must agree.
Moreover, data being passed to \code{x} and \code{y} must not contain missing or infinite values.
}
\examples{
library(fastmit)
set.seed(1)
x <- rnorm(100)
y <- x + rnorm(100)
mi(x, y, k = 5, distance = FALSE)

set.seed(1)
x <- rnorm(100)
y <- 100 * x + rnorm(100)
distx <- dist(x)
disty <- dist(y)
mi(distx, disty, k = 5, distance = TRUE)
}
\references{
Kraskov, A., Stögbauer, H., & Grassberger, P. (2004). Estimating mutual information. Physical review E 69(6): 066138.
}
