% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrs.fast.r
\name{qrs.fast}
\alias{qrs.fast}
\title{qrs.fast}
\usage{
qrs.fast(y, x, d, z, w = NULL, Q1, Q2, P = 10, link, family, gridtheta, m = 1)
}
\arguments{
\item{y}{= Dependent variable (N x 1)}

\item{x}{= Regressors matrix (N x K)}

\item{d}{= Participation variable (N x 1)}

\item{z}{= Regressors and instruments matrix for the propensity score
(N x Kz)}

\item{w}{= Sample weights (N x 1)}

\item{Q1}{= Number of quantiles in reduced grid}

\item{Q2}{= Number of quantiles in large grid}

\item{P}{=  Number of evaluated values of parameter with large quantile
grid}

\item{link}{= Link function to compute the propensity score}

\item{family}{= Parametric copula family}

\item{gridtheta}{= Grid of values for copula parameter (T x 1)}

\item{m}{=  Parameter to select interval of observations in top and bottom
groups}
}
\value{
gamma = Estimated gamma coefficients (Kz x 1)

beta = Estimated beta coefficients (K x Q2)

theta = Estimated copula parameter

objf = Value of objective function at the optimum

b1 = Estimated beta coefficients for the grid of values of the
copula parameter with the reduced quantile grid (K x Q1 x T)
}
\description{
Estimation of Quantile Regression with Selection (QRS) using Algorithm 3
for the estimation of the quantile and copula coefficients.
}
\examples{
\donttest{
set.seed(1)

N <- 100
x <- cbind(1, 2 + runif(N))
z <- cbind(x, runif(N))
cop <- copula::normalCopula(param = -0.5, dim = 2)
copu <- copula::rCopula(N, cop)
v <- copu[,1]
u <- copu[,2]
gamma <- c(-1.5, 0.05, 2)
beta <- cbind(qnorm(u), u^0.5)
prop <- exp(z \%*\% gamma) / (1 + exp(z \%*\% gamma))
d <- as.numeric(v <= prop)
y <- d * rowSums(x * beta)
w <- matrix(1, nrow = N, ncol = 1)

Q1 <- 9
Q2 <- 19
P <- 2
m <- 1
gridtheta <- seq(from = -1, to = 0, by = .1)
link <- "probit"
family <- "Gaussian"

result <- qrs.fast(y, x[,-1], d, z[,-1], w, Q1, Q2, P, link, family, gridtheta, m)
summary(result)
}
}
