% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_adset.R
\name{fbad_create_adset}
\alias{fbad_create_adset}
\title{Create Ad Set}
\usage{
fbad_create_adset(
  fbacc,
  name,
  optimization_goal = c("NONE", "APP_INSTALLS", "CLICKS", "ENGAGED_USERS", "EXTERNAL",
    "EVENT_RESPONSES", "IMPRESSIONS", "LINK_CLICKS", "OFFER_CLAIMS",
    "OFFSITE_CONVERSIONS", "PAGE_ENGAGEMENT", "PAGE_LIKES", "POST_ENGAGEMENT", "REACH",
    "SOCIAL_IMPRESSIONS", "VIDEO_VIEWS"),
  billing_event = c("APP_INSTALLS", "CLICKS", "IMPRESSIONS", "LINK_CLICKS",
    "OFFER_CLAIMS", "PAGE_LIKES", "POST_ENGAGEMENT", "VIDEO_VIEWS"),
  is_autobid = FALSE,
  bid_amount,
  promoted_object,
  campaign_id,
  status = c("ACTIVE", "PAUSED", "ARCHIVED", "DELETED"),
  daily_budget,
  lifetime_budget,
  end_time,
  start_time,
  targeting,
  ...
)
}
\arguments{
\item{fbacc}{(optional) \code{FB_Ad_account} object, which defaults to the last returned object of \code{\link{fbad_init}}.}

\item{name}{name of the Ad Set}

\item{optimization_goal}{optimization goal}

\item{billing_event}{the billing event}

\item{is_autobid}{logical. If \code{TRUE}, autobid is set and you do not need to specify \code{bid_amount}}

\item{bid_amount}{integer}

\item{promoted_object}{see at \url{https://developers.facebook.com/docs/marketing-api/reference/ad-promoted-object}}

\item{campaign_id}{parent Ad Campaign id}

\item{status}{Ad Set status}

\item{daily_budget}{using account currency}

\item{lifetime_budget}{using account currency}

\item{end_time}{UTC UNIX timestamp}

\item{start_time}{UTC UNIX timestamp}

\item{targeting}{list}

\item{...}{further arguments passed to the API endpoint}
}
\value{
Ad Set id
}
\description{
Create Ad Set
}
\references{
\url{https://developers.facebook.com/docs/marketing-api/reference/ad-campaign#Creating}
}
