% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbroc.methods.R
\name{plot.fbroc.conf}
\alias{plot.fbroc.conf}
\title{Plots function for object of class{fbroc.conf}}
\usage{
\method{plot}{fbroc.conf}(x, col = "blue", fill = "royalblue1",
  print.plot = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{fbroc.conf} to be plotted.}

\item{col}{Color of the curve to be drawn.}

\item{fill}{Fill of the confidence region.}

\item{print.plot}{Logical specifying whether the plot should be printed.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A ggplot, so that the user can customize the plot further.
}
\description{
Given an object of class \code{fbroc.conf} this function plots the contained estimates for 
the confidence region of the ROC curve.
}
\examples{
data(roc.examples)
example <- boot.roc(roc.examples$Cont.Pred, roc.examples$True.Class, n.boot = 100)
# Confidence regions for TPR at specific FPR values
tpr.conf <- conf(example, conf.for = "tpr", steps = 50) 
plot(tpr.conf)
# Confidence regions for FPR at specific TPR values
fpr.conf <- conf(example, conf.for = "fpr", steps = 50) 
plot(fpr.conf) 
}
\seealso{
\code{\link{conf.fbroc.roc}}
}
