% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_fct.R
\name{ft_split_levels}
\alias{ft_split_levels}
\title{Split Factor Levels into Multiple Factors}
\usage{
ft_split_levels(factor_vec, delimiter, names = NULL)
}
\arguments{
\item{factor_vec}{A factor vector to split.}

\item{delimiter}{A character string used to split the factor levels.}

\item{names}{A character vector specifying names for the resulting factors. Default is \code{NULL}, in which case factors are named 'Factor1', 'Factor2', etc.}
}
\value{
A data frame containing the resulting factors.
}
\description{
Splits the levels of a factor vector into multiple factors based on a specified delimiter.
}
\examples{
# Example factor vector
factor_vec <- factor(c('red_large', 'blue_small', 'green_medium'))

# Split levels into two factors
ft_split_levels(factor_vec, delimiter = '_')
}
\author{
Kai Guo
}
