% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{plot.som}
\alias{plot.som}
\title{Plot function for som-class}
\usage{
\method{plot}{som}(x, type = c("scatter", "mapping"), col = NULL, labels = FALSE, ...)
}
\arguments{
\item{x}{The Kohonen's map (object of class \code{\link{som-class}}).}

\item{type}{The type of plot.}

\item{col}{Color of the data points}

\item{labels}{A \code{vector} of character strings to be printed instead of points in the plot.}

\item{...}{Other parameters.}
}
\description{
Plot Kohonen's self-organizing maps.
}
\examples{
require (datasets)
data (iris)
som = SOM (iris [, -5], xdim = 5, ydim = 5, post = "ward", k = 3)
plot (som) # Scatter plot (default)
plot (som, type = "mapping") # Kohonen map
}
\seealso{
\code{\link{SOM}}, \code{\link{som-class}}
}
