% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{predict.boosting}
\alias{predict.boosting}
\title{Model predictions}
\usage{
\method{predict}{boosting}(object, test, fuzzy = FALSE, ...)
}
\arguments{
\item{object}{The classification model (of class \code{\link{boosting-class}}, created by \code{\link{ADABOOST}} or \code{\link{BAGGING}}).}

\item{test}{The test set (a \code{data.frame})}

\item{fuzzy}{A boolean indicating whether fuzzy classification is used or not.}

\item{...}{Other parameters.}
}
\value{
A vector of predicted values (\code{factor}).
}
\description{
This function predicts values based upon a model trained by a boosting method.
}
\examples{
\dontrun{
require (datasets)
data (iris)
d = splitdata (iris, 5)
model = BAGGING (d$train.x, d$train.y, NB)
predict (model, d$test.x)
model = ADABOOST (d$train.x, d$train.y, NB)
predict (model, d$test.x)
}
}
\seealso{
\code{\link{ADABOOST}}, \code{\link{BAGGING}}, \code{\link{boosting-class}}
}
