% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{roc.curves}
\alias{roc.curves}
\title{Plot ROC Curves}
\usage{
roc.curves(predictions, gt, methods.names = NULL)
}
\arguments{
\item{predictions}{The predictions of a classification model (\code{factor} or \code{vector}).}

\item{gt}{Actual labels of the dataset (\code{factor} or \code{vector}).}

\item{methods.names}{The name of the compared methods (\code{vector}).}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
This function plots ROC Curves of several classification predictions.
}
\examples{
require (datasets)
data (iris)
d = iris
levels (d [, 5]) = c ("+", "+", "-") # Building a two classes dataset
model.nb = NB (d [, -5], d [, 5])
model.lda = LDA (d [, -5], d [, 5])
pred.nb = predict (model.nb, d [, -5])
pred.lda = predict (model.lda, d [, -5])
roc.curves (cbind (pred.nb, pred.lda), d [, 5], c ("NB", "LDA"))
}
\seealso{
\code{\link{cost.curves}}, \code{\link{performance}}
}
