% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feepred.r
\name{feepred}
\alias{feepred}
\title{Predicted Counts from One-Inflated or Truncated Count Models}
\usage{
feepred(model, data, maxpred)
}
\arguments{
\item{model}{A fitted model object of class \code{"oneinflmodel"}, \code{"truncmodel"}, or \code{"basicPoisson"}.}

\item{data}{A data frame containing the covariates used to fit the model.}

\item{maxpred}{Optional integer specifying the maximum count value for which to compute predicted frequencies.
If not supplied, defaults to the maximum observed count in the data.}
}
\value{
A numeric vector of length \code{maxpred}, giving the predicted expected frequency of each count from 1 to \code{maxpred}.
}
\description{
Computes the predicted count distribution from a fitted model of class \code{"oneinflmodel"},
\code{"truncmodel"}, or \code{"basicPoisson"}. The function returns the expected frequency
for each count value from 1 up to \code{maxpred}, based on the model's parameters.
}
\details{
The function determines the model type based on its class and the \code{dist} attribute, and applies the appropriate
density function:
\itemize{
  \item For \code{oneinflmodel} (Poisson): one-inflated positive Poisson distribution.
  \item For \code{oneinflmodel} (negbin): one-inflated zero-truncated negative binomial.
  \item For \code{truncmodel} (Poisson): truncated positive Poisson.
  \item For \code{truncmodel} (negbin): zero-truncated negative binomial.
}
}
\examples{
df <- data.frame(x = runif(10,0,10), d = sample(c(0,1), 10, replace=TRUE), y = rpois(10, 3) + 1)
model <- oneinfl::oneinfl(formula = y ~ x + d | x + d, df = df, dist = "Poisson")
feepred(model, data = df)

}
\seealso{
\code{\link{feeplot}}, \code{\link{fee}}, \code{\link{dfee}}
}
