% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_import_nflfastr.R
\name{nflfastr_weekly}
\alias{nflfastr_weekly}
\title{Import latest nflfastr weekly stats}
\usage{
nflfastr_weekly(seasons = TRUE, type = c("offense", "kicking"))
}
\arguments{
\item{seasons}{The seasons to return, TRUE returns all data available.}

\item{type}{One of "offense" or "kicking"}
}
\value{
Weekly stats for all passers, rushers and receivers in the nflverse play-by-play data from the 1999 season to the most recent season
}
\description{
Fetches a copy of the latest week-level stats from nflfastr's data repository, via the \href{https://nflreadr.nflverse.com}{nflreadr} package.
}
\details{
The goal of this data is to replicate the NFL's official weekly stats, which
can diverge a bit from what fantasy data feeds display.

If you have any issues with the output of this data, please open an issue in
the nflfastr repository.
}
\examples{
\donttest{
try( # try only shown here because sometimes CRAN checks are weird
  nflfastr_weekly()
)
}

}
\seealso{
\url{https://nflreadr.nflverse.com}
}
